/*****************************************************************************/
/* FILE NAME: spi.c                            COPYRIGHT (c) Freescale 2015  */
/*                                                      All Rights Reserved  */
/* DESCRIPTION: SPI functions for initialization and reading received data.  */
/*                                                                           */
/*****************************************************************************/	
/* REV      AUTHOR        DATE        DESCRIPTION OF CHANGE                  */
/* ---   -----------    ----------    ---------------------                  */
/* 1.0	 Scott Obrien   21 Apr 2015   Initial Version                        */
/*****************************************************************************/

#include "project.h"
#include "spi.h"

unsigned int RecDataMaster=0;
unsigned int RecDataSlave=0;

/*****************************************************************************/
/* Check RM for available pinout options. Connect SOUT_Master to SIN_Slave and SIN_Master to SOUT_Slave
** 
** DSPI_1 MASTER
** CLK	  PB2
** SOUT	  PA9
** SIN	  PH7
** SS/CS0 PA5
**
** DSPI_2  SLAVE
** CLK	  PA11
** SOUT	  PA12
** SIN	  PA13
** SS/CS0 PA10
*/
/*****************************************************************************/

void init_dspi_ports()
{
  /* Master - DSPI_1 */
  SIUL2.MSCR[9].B.SSS = 4;                 /* Pad PA9: Source signal is DSPI_1 SOUT, P8.10  */
  SIUL2.MSCR[9].B.OBE = 1;                 /* Pad PA9: OBE=1. */
  SIUL2.MSCR[9].B.SRC = 3;                 /* Pad PA9: Full strength slew rate */
  
  SIUL2.MSCR[18].B.SSS = 4;                /* Pad PB2: Source signal is DSPI_1 CLK, P9.3  */
  SIUL2.MSCR[18].B.OBE = 1;                /* Pad PB2: OBE=1. */
  SIUL2.MSCR[18].B.SRC = 3;                /* Pad PB2: Full strength slew rate */
  
  SIUL2.MSCR[119].B.IBE = 1;                /* Pad PH7: Enable pad for input DSPI_1 SIN, P17.2 */
  SIUL2.IMCR[6].B.SSS = 4;            		/* Pad PH7: connected to pad PH7 */

  SIUL2.MSCR[5].B.SSS = 1;                 /* Pad PA5: Source signal is DSPI_1 CS0, P8.6 */
  SIUL2.MSCR[5].B.OBE = 1;                 /* Pad PA5: OBE=1. */
  SIUL2.MSCR[5].B.SRC = 3;                 /* Pad PA5: Full strength slew rate */
  
  /* Slave - DSPI_2 */
  SIUL2.MSCR[11].B.SSS = 2;                /* Pad PA11: Source signal is DSPI_2 CLK, P8.12 */
  SIUL2.MSCR[11].B.IBE = 1;                /* Pad PA11: IBE=1. */
  SIUL2.IMCR[8].B.SSS = 2; 	           		/* Pad PA11: DSPI_2 CLK. Slave takes clock from master. Therefore input */
  
  SIUL2.MSCR[12].B.SSS = 1;                /* Pad PA12: Source signal is DSPI_2 SOUT, P8.13 */
  SIUL2.MSCR[12].B.OBE = 1;                /* Pad PA12: OBE=1. */
  SIUL2.MSCR[12].B.SRC = 3;                /* Pad PA12: Full strength slew rate */
  
  SIUL2.MSCR[13].B.IBE = 1;                /* Pad PA13: Enable pad for input DSPI_2 SIN, P8.14 */
  SIUL2.IMCR[9].B.SSS = 2;            		/* Pad PA13: connected to pad */

  SIUL2.MSCR[10].B.IBE = 1;                /* Pad PA10: IBE=1. DSPI_2 SS, P8.11 */
  SIUL2.IMCR[10].B.SSS = 2;            		/* Pad PA10: connected to pad */
}

/*****************************************************************************/

void init_dspi_1(void)
{
  SPI_1.MCR.R = 0x80010001;                /* Configure DSPI_1 as master */
  SPI_1.MODE.CTAR[0].R = 0x78021004;       /* Configure CTAR0  */
  SPI_1.MCR.B.HALT = 0x0;                  /* Exit HALT mode: go from STOPPED to RUNNING state*/
}

void init_dspi_2(void)
{
	SPI_2.MCR.R = 0x00010001;                 /* Configure DSPI_1 as slave */
	SPI_2.MODE.CTAR[0].R = 0x78021004;        /* Configure CTAR0  */
	SPI_2.MCR.B.HALT = 0x0;                   /* Exit HALT mode: go from STOPPED to RUNNING state*/
}

void read_data_DSPI_1(void) {
  while (SPI_1.SR.B.RFDF != 1){}           /* Wait for Receive FIFO Drain Flag = 1 */
  RecDataMaster = SPI_1.POPR.R;             /* Read data received by master SPI */
  SPI_1.SR.R = 0xFCFE0000;                 /* Clear ALL status flags by writing 1 to them */
}

void read_data_DSPI_2(void) {
  while (SPI_2.SR.B.RFDF != 1){}            /* Wait for Receive FIFO Drain Flag = 1 */
  RecDataSlave = SPI_2.POPR.R;             /* Read data received by slave SPI */
  SPI_2.SR.R = 0xFCFE0000;                  /* Clear ALL status flags by writing 1 */
}

/*****************************************************************************/

void init_dspi_clk(void){
	CGM.AC12_SC.B.SELCTL = 2; //Source of SPI_CLK is PLL0_PHI_CLK
	CGM.AC12_DC0.R = 0x80030000; //Set to 40 MHz
}
